# Matlab

Matlab files/examples for Gantner device communication or file decoding, including c-code for generating mex-files (64/32bit).

**Copy .dll:** `giutility.dll` can be copied manually from `../bin/windows/x64/giutility.dll` or using `GInsInit.m`.

**Warning**
Changed name of mex files from `read_exact.mex` to `GInsMex.mex`.

## Examples

Several examples are available that show the usage of the mex file and direct calls to the DLL. 
As a starting point for mex files, the `HSP_ReadBuffer` example provides some functions in a GUI.
Otherwise the example `Mex_PPB_ReadMicrophone` is based on the GI.bench microphone example and reads values from a connected microphone.


In order to use the examples a rebuild of the mex file may be useful. For this, please refer to the next section. 
If the .dll library should be used directly, copy `giutility.dll` from the installation path of GI.bench into this Matlab folder or add the installation path with `addpath('C:\Program Files\Gantner Instruments\GI.bench');`. 

## Rebuild Mex files:

To rebuild the `GInsMex.mexw64` or `GInsMex.mexw32` in case the `GInsMex.c` file was modified, type `mex GInsMex.c` or `BuildMexFile` in Matlab command window (GInsMex.c has to be in the current directory or the directory must be added to Matlab path). 

Note: a compatible compiler is required! Check with `mex -setup` for available compilers on your system. 





## Load C/C++ shared library

The syntax to load a library directly in Matlab (without using the mex-file) is for example

`loadlibrary('giutility','eGateHighSpeedPort.h','alias','HighSpeedPortDLL');`

Limitation: a supported C compiler must be available!
See for detailled info for loadlibrary: https://de.mathworks.com/help/matlab/ref/loadlibrary.html


### Call Function in shared library
A DLL Function can be called from a loaded library for example

`calllib('HighSpeedPortDLL','CD_eGateHighSpeedPort_Init',host,timeout,conType,10,hclient,hconnection);`

See for detailled info for calllib: https://de.mathworks.com/help/matlab/ref/calllib.html
