%% Add path of mex file and subfolders
disp("Adding examples to Matlab path...");
addpath(genpath(pwd));
% savepath      %% Save example path persistent

%% Copy library

% Copy .lib depending on architeccture
disp("Copy giutility library...");
arch = computer;
if (arch == 'PCWIN64')
    copyfile '../c++/lib/x64/giutility.lib'
elseif (arch == 'PCWIN')
    copyfile '../c++/lib/x86/giutility.lib'
else
    disp("ERROR: Failed to copy giutility.lib. Try to copy dll from GI.bench default installation path");

    % Copy .dll from GI.bench default installation path
    rc = copyfile ('C:\Program Files\Gantner Instruments\GI.bench\giutility.dll');
    if (rc == 0)
        disp("ERROR: Failed to copy giutility.dll from GI.bench.");
    end
end

%% Build mex file
try
    disp("Rebuild mex file...");
    mex GInsMex.c
catch
end

%% Clean up
clear rc arch

disp("Init finished!");