%% Clean up
clc; clear; close all;
ret = GInsMex(6);       % Disconnect if needed


%% Input 
secondsToRecord = 30; % Take last 30 seconds

%% Set microphone stream as source

[ BufferIDs, BufferNames ] = Mex_PPB_ScanBuffers();

% Find microphone stream
micStreamId = "";
for idx = 1 : max(size(BufferNames))
    if (strcmp(string(BufferNames(idx)), "microphone_stream"))
        micStreamId = string(BufferIDs(idx));
        break;
    end
end

% Connect to microphone stream
ret = GInsMex(14, char(micStreamId));
if (ret ~= 0)
    return;
end

% Set back time
ret = GInsMex(15, secondsToRecord);


%% Check data source
[ret, NumberOfChannels] = GInsMex(3);       % Number of Channels

% print channel names
channels = "";
for i = 1:NumberOfChannels
    [ret, channels(i,1)] = GInsMex(4, i-1);
end



%% Read Online Data

% Get sample rate
[ret sampleRate] = GInsMex(7);

dataLength = sampleRate*secondsToRecord;      % record n seconds
data = zeros(dataLength, NumberOfChannels);

for i = 1 : dataLength
    [ret, data(i,:)] = GInsMex(5, 0, NumberOfChannels, [0:NumberOfChannels-1]);
    if (ret ~= 0)
        "Error"
    end
end


%% Process data
% Timestamp
time = (0 : 1/sampleRate : secondsToRecord)';
time = time(1:end-1);

% Data
micData = data(:,2);


%% Plotting
figure
plot(time, micData)
xlabel("Time in s")
ylabel("Microphone Value")
grid on


%% Close connection
ret = GInsMex(6);