
clc

[BufferIDs, BufferNames] = Mex_PPB_ScanBuffers;

fprintf('%i buffers found \n',size(BufferIDs,1))

if (size(BufferIDs,1) > 0)
    
    BufferIDs
    
    for j = 1:size(BufferIDs,1)
        bufferID = char(BufferIDs(j,:));
        fprintf('\n -> Connecting to buffer %i, ID %s \n \n',j,bufferID); 

        %use workmode 14 to connect to postprocess buffer:
        ret = GInsMex(14, bufferID);

        numChannels = 0;
        if(ret == 0)
           [ret, numChannels] = GInsMex(3);
           fprintf('Found %i channels in buffer %i\n',numChannels, j); 
           Channels = [];
           for i = 1:numChannels
               [ret, strChannel] = GInsMex(4,i-1);
               if ret ~= 0
                   break;
               end
               Channels = strvcat(Channels,strChannel);
           end
        end

        if ret ~= 0
           fprintf('Error connecting to buffer, ID %s',bufferID);
        end

        Channels

        fprintf('Disconnect... \n \n ');
        ret = GInsMex(6); 
    end  
end

