﻿using System.Globalization;
using G5.Api.Example.Model;
using Regatron.G5.Api.System;

namespace G5.Api.Example.ViewModel
{
  internal class MainWindowViewModel : BindableBase
  {
    private readonly CultureInfo _cultureInfo = new CultureInfo("en-us");
    private bool _isDevice1Connected;
    private bool _isDevice2Connected;
    private string _apiErrorMessage = "No error";

    private readonly G5System _g5System1;
    private readonly G5System _g5System2;
    
    public bool IsDevice1Connected
    {
      get => _isDevice1Connected;
      set => SetProperty(ref _isDevice1Connected, value);
    }

    public bool IsDevice2Connected
    {
      get => _isDevice2Connected;
      set => SetProperty(ref _isDevice2Connected, value);
    }  

    public string ApiErrorMessage
    {
      get => _apiErrorMessage;
      set => SetProperty(ref _apiErrorMessage, value);
    }

    public ConnectionTabControlViewModel ConnectionTabControlViewModel1 { get; }
    public ConnectionTabControlViewModel ConnectionTabControlViewModel2 { get; }
    public DeviceInformationTabControlViewModel DeviceInformationTabControlViewModel1 { get; }
    public DeviceInformationTabControlViewModel DeviceInformationTabControlViewModel2 { get; }
    public FunctionGeneratorTabControlViewModel FunctionGeneratorTabControlViewModel1 { get; }
    public FunctionGeneratorTabControlViewModel FunctionGeneratorTabControlViewModel2 { get; }

    internal MainWindowViewModel()
    {
      _g5System1 = G5System.CreateSystem();
      _g5System1.ConnectionChanged += G5System1ConnectionChanged;
      _g5System2 = G5System.CreateSystem();
      _g5System2.ConnectionChanged += G5System2ConnectionChanged;

      var connectionService1 = new ConnectionService(_g5System1);
      var connectionService2 = new ConnectionService(_g5System2);
      var deviceInformationService1 = new DeviceInformationService(_g5System1);
      var deviceInformationService2 = new DeviceInformationService(_g5System2);
      var functionGeneratorService1 = new FunctionGeneratorService(_g5System1);
      var functionGeneratorService2 = new FunctionGeneratorService(_g5System2);
      connectionService1.ErrorMessageChanged += ErrorMessageChangedHandler;
      connectionService2.ErrorMessageChanged += ErrorMessageChangedHandler;
      deviceInformationService1.ErrorMessageChanged += ErrorMessageChangedHandler;
      deviceInformationService2.ErrorMessageChanged += ErrorMessageChangedHandler;
      functionGeneratorService1.ErrorMessageChanged += ErrorMessageChangedHandler;
      functionGeneratorService2.ErrorMessageChanged += ErrorMessageChangedHandler;

      ConnectionTabControlViewModel1 = new ConnectionTabControlViewModel(connectionService1);
      ConnectionTabControlViewModel2 = new ConnectionTabControlViewModel(connectionService2);

      DeviceInformationTabControlViewModel1 = new DeviceInformationTabControlViewModel(deviceInformationService1, connectionService1);
      DeviceInformationTabControlViewModel2 = new DeviceInformationTabControlViewModel(deviceInformationService2, connectionService2);

      FunctionGeneratorTabControlViewModel1 = new FunctionGeneratorTabControlViewModel(functionGeneratorService1, connectionService1, _cultureInfo);
      FunctionGeneratorTabControlViewModel2 = new FunctionGeneratorTabControlViewModel(functionGeneratorService2, connectionService2, _cultureInfo);
    }

    private void ErrorMessageChangedHandler(object sender, ValueChangedEventArgs e)
    {
      if (e.NewValue is string errorMessage)
      {
        ApiErrorMessage = errorMessage;
      }
      else
      {
        ApiErrorMessage = "Some unknown error occured.";
      }
    }

    private void G5System1ConnectionChanged(bool connected)
    {
      IsDevice1Connected = connected;
    }

    private void G5System2ConnectionChanged(bool connected)
    {
      IsDevice2Connected = connected;
    }



    public void DisconnectAllSystems()
    {
      ConnectionTabControlViewModel1.DisconnectCommand.Execute(this);
      ConnectionTabControlViewModel2.DisconnectCommand.Execute(this);
    }
  }
}
