﻿using G5.Api.Example.Model;
using Regatron.G5.Api;
using System;
using System.Windows.Input;

namespace G5.Api.Example.ViewModel
{
  internal class DeviceInformationTabControlViewModel : BindableBase, IDeviceInformationTabControlViewModel
  {
    private const string VoltageOnStringConstant = "Voltage on";
    private const string VoltageOffStringConstant = "Voltage off";
    private const string VoltageOnButtonStringConstant = "Set voltage on";
    private const string VoltageOffButtonStringConstant = "Set voltage off";

    private readonly IDeviceInformationService _deviceInformationService;
    private readonly IConnectionService _connectionService;

    private float _voltageReference;
    private string _voltageReferenceString;
    private string _actualVoltageReferenceString;
    private float _upperCurrentLimit;
    private string _upperCurrentLimitString;
    private string _actualUpperCurrentLimitString;
    private float _upperPowerLimit;
    private string _upperPowerLimitString;
    private string _actualUpperPowerLimitString;
    private ICommand _setVoltageControlModeCommand;
    private string _actualControlModeString;
    private ICommand _getActualErrorsCommand;
    private string _actualErrorString;
    private ICommand _getDeviceStateCommand;
    private string _actualDeviceStateString;
    private ICommand _setVoltageOnOffCommand;
    private string _setVoltageOnOffButtonString;
    private string _voltageIsOnOffString;
    private bool _isVoltageOn;
    private ICommand _updateValuesFromDeviceCommand;

    public string VoltageReferenceString
    {
      get => _voltageReferenceString;
      set
      {
        if (float.TryParse(value, out _voltageReference))
        {
          SetProperty(ref _voltageReferenceString, value);
          _deviceInformationService.SetReferenceVoltage(_voltageReference);
          UpdateReferenceValuesFromDevice();
        }
        else
        {
          SetProperty(ref _voltageReferenceString, String.Empty);
        }
      }
    }

    public string ActualVoltageReferenceString
    {
      get => _actualVoltageReferenceString;
      set => SetProperty(ref _actualVoltageReferenceString, value);
    }

    public string UpperCurrentLimitString
    {
      get => _upperCurrentLimitString;
      set
      {
        if (float.TryParse(value, out _upperCurrentLimit))
        {
          SetProperty(ref _upperCurrentLimitString, value);
          _deviceInformationService.SetMaximumCurrent(_upperCurrentLimit);
          UpdateReferenceValuesFromDevice();
        }
        else
        {
          SetProperty(ref _upperCurrentLimitString, String.Empty);
        }
      }
    }

    public string ActualUpperPowerLimitString
    {
      get => _actualUpperPowerLimitString;
      set => SetProperty(ref _actualUpperPowerLimitString, value);
    }

    public string UpperPowerLimitString
    {
      get => _upperPowerLimitString;
      set
      {
        if (float.TryParse(value, out _upperPowerLimit))
        {
          SetProperty(ref _upperPowerLimitString, value);
          _deviceInformationService.SetMaximumPower(_upperPowerLimit);
          UpdateReferenceValuesFromDevice();
        }
        else
        {
          SetProperty(ref _upperPowerLimitString, String.Empty);
        }
      }
    }

    public string ActualUpperCurrentLimitString
    {
      get => _actualUpperCurrentLimitString;
      set => SetProperty(ref _actualUpperCurrentLimitString, value);
    }

    public ICommand SetVoltageControlModeCommand
    {
      get => _setVoltageControlModeCommand;
      set => SetProperty(ref _setVoltageControlModeCommand, value);
    }

    public string ActualControlModeString
    {
      get => _actualControlModeString;
      set => SetProperty(ref _actualControlModeString, value);
    }

    public ICommand GetActualErrorsCommand
    {
      get => _getActualErrorsCommand;
      set => SetProperty(ref _getActualErrorsCommand, value);
    }

    public string ActualErrorString
    {
      get => _actualErrorString;
      set => SetProperty(ref _actualErrorString, value);
    }
    public ICommand GetDeviceStateCommand
    {
      get => _getDeviceStateCommand;
      set => SetProperty(ref _getDeviceStateCommand, value);
    }

    public string ActualDeviceStateString
    {
      get => _actualDeviceStateString;
      set => SetProperty(ref _actualDeviceStateString, value);
    }

    public ICommand SetVoltageOnOffCommand
    {
      get => _setVoltageOnOffCommand;
      set => SetProperty(ref _setVoltageOnOffCommand, value);
    }

    public string SetVoltageOnOffButtonString
    {
      get => _setVoltageOnOffButtonString;
      set => SetProperty(ref _setVoltageOnOffButtonString, value);
    }

    public string VoltageIsOnOffString
    {
      get => _voltageIsOnOffString;
      set => SetProperty(ref _voltageIsOnOffString, value);
    }

    public bool IsVoltageOn
    {
      get => _isVoltageOn;
      set => SetProperty(ref _isVoltageOn, value);
    }

    public ICommand UpdateValuesFromDeviceCommand
    {
      get => _updateValuesFromDeviceCommand;
      set => SetProperty(ref _updateValuesFromDeviceCommand, value);
    }

    public DeviceInformationTabControlViewModel(IDeviceInformationService deviceInformationService, IConnectionService connectionService)
    {
      _deviceInformationService = deviceInformationService ?? throw new ArgumentNullException();
      _connectionService = connectionService ?? throw new ArgumentNullException();
      _connectionService.ConnectionChanged += ConnectionChangedHandler;

      SetVoltageControlModeCommand = new BaseCommand(notNeededArgument => SetVoltageControlMode(), (notNeededArgument) => _connectionService.IsConnected);
      GetActualErrorsCommand = new BaseCommand(notNeededArgument => GetActualErrors(), (notNeededArgument) => _connectionService.IsConnected);
      GetDeviceStateCommand = new BaseCommand(notNeededArgument => GetDeviceState(), (notNeededArgument) => _connectionService.IsConnected);
      SetVoltageOnOffCommand = new BaseCommand(notNeededArgument => SetVoltageOnOff(), (notNeededArgument) => _connectionService.IsConnected);
      UpdateValuesFromDeviceCommand = new BaseCommand(notNeededArgument => UpdateReferenceValuesFromDevice(), (notNeededArgument) => _connectionService.IsConnected);
    }

    private void ConnectionChangedHandler(object sender, ValueChangedEventArgs e)
    {
      UpdateReferenceValuesFromDevice();
    }

    private void SetVoltageControlMode()
    {
      _deviceInformationService.SetVoltageControlMode();
    }

    private void GetActualErrors()
    {
      ActualErrorString = _deviceInformationService.GetActualErrorsAsString();
    }

    private void GetDeviceState()
    {
      ActualDeviceStateString = _deviceInformationService.GetDeviceStateAsString();
    }

    private void SetVoltageOnOff()
    {
      if (_deviceInformationService.IsVoltageOn())
      {
        _deviceInformationService.SetVoltageOff();
      }
      else
      {
        _deviceInformationService.SetVoltageOn();
      }
      UpdateIsVoltageOn();
    }

    private void UpdateIsVoltageOn()
    {
      if (_connectionService.IsConnected)
      {
        IsVoltageOn = _deviceInformationService.IsVoltageOn();
        VoltageIsOnOffString = IsVoltageOn ? VoltageOnStringConstant : VoltageOffStringConstant;
        SetVoltageOnOffButtonString = IsVoltageOn ? VoltageOffButtonStringConstant : VoltageOnButtonStringConstant;
      }
    }

    private void UpdateReferenceValuesFromDevice()
    {
      if (_connectionService.IsConnected)
      {
        var referenceValues = _deviceInformationService.ReadReferenceValuesFromDevice();

        ActualVoltageReferenceString = $"{referenceValues.ActualVoltageReference} V";
        ActualUpperCurrentLimitString = $"{referenceValues.ActualUpperCurrentLimit} A";
        ActualUpperPowerLimitString = $"{referenceValues.ActualUpperPowerLimit} W";
      }
      UpdateIsVoltageOn();
    }
  }
}
