﻿using System.Globalization;
using System;
using System.Windows.Data;
using G5.Api.Example.Model;

namespace G5.Api.Example.ViewModel.Converters
{
  internal class SasCellTechnologySelectionToBooleanConverter : IValueConverter
  {
    public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
    {
      bool result = default;
      if (value is SasCellTechnology cellTechnology)
      {
        switch (cellTechnology)
        {
          case SasCellTechnology.Csi:
          case SasCellTechnology.ThinFilm:
            result = false;
            break;
          case SasCellTechnology.UserDefined:
            result = true;
            break;
          default:
            throw new NotImplementedException();
        }
      }

      return result;
    }

    public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
    {
      throw new NotImplementedException();
    }
  }
}
