﻿using G5.Api.Example.Model;
using System;
using System.Windows.Input;

namespace G5.Api.Example.ViewModel
{
  internal class ConnectionTabControlViewModel : BindableBase, IConnectionTabControlViewModel
  {
    private bool _isConnected;
    private ICommand _connectCommand;
    private ICommand _disconnectCommand;
    private string _ipString;
    private string _portString;
    private ushort _port;

    public bool IsConnected
    {
      get => _isConnected;
      set => SetProperty(ref _isConnected, value);
    }
    public ICommand ConnectCommand
    {
      get => _connectCommand;
      set => SetProperty(ref _connectCommand, value);
    }
    public ICommand DisconnectCommand
    {
      get => _disconnectCommand;
      set => SetProperty(ref _disconnectCommand, value);
    }

    public string IpString
    {
      get => _ipString;
      set => SetProperty(ref _ipString, value);
    }
    public string PortString
    {
      get => _portString;
      set
      {
        if (ushort.TryParse(value, out _port))
        {
          SetProperty(ref _portString, value);
        }
        else
        {
          SetProperty(ref _portString, String.Empty);
        }
      }
    }

    public ConnectionTabControlViewModel(IConnectionService connectionService)
    {
      PortString = "2000";
      ConnectCommand = new BaseCommand(notNeededArgument => { connectionService.Connect(IpString, _port); IsConnected = connectionService.IsConnected; }, (notNeededArgument) => !IsConnected);
      DisconnectCommand = new BaseCommand(notNeededArgument => { connectionService.Disconnect(); IsConnected = connectionService.IsConnected; }, (notNeededArgument) => IsConnected);
    } 
  }
}
