﻿using Regatron.G5.Api.System;
using System;

namespace G5.Api.Example.ViewModel
{
  internal class CellTechnologyParametersViewModel : BindableBase, ICellTechnologyParametersViewModel
  {
    private string _ffvString;
    private float _ffv;
    private string _ffiString;
    private float _ffi;
    private string _alphaString;
    private float _alpha;
    private string _betaString;
    private float _beta;
    private string _cgString;
    private float _cg;
    private string _cvString;
    private float _cv;
    private string _crString;
    private float _cr;
    private string _nuL2HString;
    private float _nu2Lh;

    public float Ffv => _ffv;
    public float Ffi => _ffi;
    public float Alpha => _alpha;
    public float Beta => _beta;
    public float Cg => _cg;
    public float Cv => _cv;
    public float Cr => _cr;
    public float Nu2Lh => _nu2Lh;

    public string FfvString
    {
      get => _ffvString;
      set
      {
        if (float.TryParse(value, out _ffv))
        {
          SetProperty(ref _ffvString, value);
        }
        else
        {
          SetProperty(ref _ffvString, String.Empty);
        }
      }
    }
    
    public string FfiString
    {
      get => _ffiString;
      set
      {
        if (float.TryParse(value, out _ffi))
        {
          SetProperty(ref _ffiString, value);
        }
        else
        {
          SetProperty(ref _ffiString, String.Empty);
        }
      }
    }

    public string AlphaString
    {
      get => _alphaString;
      set
      {
        if (float.TryParse(value, out _alpha))
        {
          SetProperty(ref _alphaString, value);
        }
        else
        {
          SetProperty(ref _alphaString, String.Empty);
        }
      }
    }

    public string BetaString
    {
      get => _betaString;
      set
      {
        if (float.TryParse(value, out _beta))
        {
          SetProperty(ref _betaString, value);
        }
        else
        {
          SetProperty(ref _betaString, String.Empty);
        }
      }
    }

    public string CgString
    {
      get => _cgString;
      set
      {
        if (float.TryParse(value, out _cg))
        {
          SetProperty(ref _cgString, value);
        }
        else
        {
          SetProperty(ref _cgString, String.Empty);
        }
      }
    }

    public string CvString
    {
      get => _cvString;
      set
      {
        if (float.TryParse(value, out _cv))
        {
          SetProperty(ref _cvString, value);
        }
        else
        {
          SetProperty(ref _cvString, String.Empty);
        }
      }
    }

    public string CrString
    {
      get => _crString;
      set
      {
        if (float.TryParse(value, out _cr))
        {
          SetProperty(ref _crString, value);
        }
        else
        {
          SetProperty(ref _crString, String.Empty);
        }
      }
    }

    public string NuL2HString
    {
      get => _nuL2HString;
      set
      {
        if (float.TryParse(value, out _nu2Lh))
        {
          SetProperty(ref _nuL2HString, value);
        }
        else
        {
          SetProperty(ref _nuL2HString, String.Empty);
        }
      }
    }

    public SolarArraySimulationCellTechnologyParameters GetSolarArraySimulationCellTechnologyParameters()
    {
      return new SolarArraySimulationCellTechnologyParameters(_ffv, _ffi, _cg, _cv, _cr, _alpha, _beta, _nu2Lh);
    }
  }
}
