﻿using System;
using System.Windows.Input;

namespace G5.Api.Example.ViewModel
{
  /// <summary>
  ///     Simple implementation of ICommand.
  /// </summary>
  internal class BaseCommand : ICommand
  {
    private readonly Predicate<object> _canExecute;
    private readonly Action<object> _execute;

    public BaseCommand(Action<object> execute, Predicate<object> canExecute)
    {
      if (execute == null)
      {
        throw new ArgumentNullException("execute");
      }
      _execute = execute;
      _canExecute = canExecute;
    }

    #region //---- ICommand Members ----

    /// <summary>
    ///     True if the command can execute.
    /// </summary>
    public bool CanExecute(object parameter)
    {
      return _canExecute == null || _canExecute(parameter);
    }

    public event EventHandler CanExecuteChanged
    {
      add { CommandManager.RequerySuggested += value; }
      remove { CommandManager.RequerySuggested -= value; }
    }

    /// <summary>
    ///     Execute the command.
    /// </summary>
    public void Execute(object parameter)
    {
      _execute(parameter);
    }

    #endregion
  }
}