﻿using Regatron.G5.Api.System;
using Regatron.G5.Common;

namespace G5.Api.Example.Model
{
  internal interface IFunctionGeneratorService
  {
    void SetControlMode(FunctionGeneratorControlMode controlMode);
    void SetBaseFunction(FunctionGeneratorFunctionType functionType);
    void SetBlockFunctionRepetitions(uint blockFunctionRepetitions);
    void SetPeakValue(float peakValue);
    void SetOffset(float offset);
    void SetFrequency(float frequency);
    void SetSymmetry(float symmetry);
    void SetTriggerMode(FunctionGeneratorTriggerMode triggerMode);
    void SetSequenceFinishBehavior(FunctionGeneratorSequenceFinishBehaviour sequenceFinishBehavior);
    void SetBlockRepetitions(uint blockRepetitions);
    void SetSequenceDelay(float sequenceDelay);
    FunctionGeneratorValuesDTO ReadFunctionGeneratorValuesFromDevice();
    void SetFunctionGeneratorCommand(FunctionGeneratorCommand functionGeneratorCommand);
    FunctionGeneratorState GetFunctionGeneratorState();
    SasSpecificFunctionGeneratorValuesDTO ReadSasSpecificFunctionGeneratorValuesFromDevice();
    void SetSasCurve(float mppVoltage, float mppCurrent, SasCellTechnology sasCellTechnology, SolarArraySimulationCellTechnologyParameters cellTechnologyParameters);
    void SetActualIrradiance(float actualIrradiance, float rampTime);
    void SetActualTemperature(float actualTemperature, float rampTime);
  }
}
