﻿using Regatron.G5.Common;

namespace G5.Api.Example.Model
{
  internal class FunctionGeneratorValuesDTO
  {
    public FunctionGeneratorControlMode ControlMode { get;}
    public FunctionGeneratorFunctionType FunctionType { get;}
    public float FunctionRepetitions { get;}
    public float PeakValue { get;}
    public float Offset { get;}
    public float Frequency { get;}
    public float Symmetry { get;}
    public FunctionGeneratorTriggerMode TriggerMode { get;}
    public FunctionGeneratorSequenceFinishBehaviour FinishBehaviour { get;}
    public uint BlockRepetitions { get; }
    public float SequenceDelay { get; }

    public FunctionGeneratorValuesDTO(FunctionGeneratorControlMode controlMode, FunctionGeneratorFunctionType functionType, float functionRepetitions, float peakValue, float offset, float frequency, float symmetry, FunctionGeneratorTriggerMode triggerMode, FunctionGeneratorSequenceFinishBehaviour finishBehaviour, uint blockRepetitions, float sequenceDelay)
    {
      ControlMode = controlMode;
      FunctionType = functionType;
      FunctionRepetitions = functionRepetitions;
      PeakValue = peakValue;
      Offset = offset;
      Frequency = frequency;
      Symmetry = symmetry;
      TriggerMode = triggerMode;
      FinishBehaviour = finishBehaviour;
      BlockRepetitions = blockRepetitions;
      SequenceDelay = sequenceDelay;
    }
  }
}
