﻿using Regatron.G5.Api;
using Regatron.G5.Api.System;
using System;

namespace G5.Api.Example.Model
{
  internal class ConnectionService : BaseService, IConnectionService
  {
    private readonly G5System _system;

    public event EventHandler<ValueChangedEventArgs> ConnectionChanged;

    public bool IsConnected  => _system?.IsConnected() ?? false;

    public ConnectionService(G5System system) 
    {
      _system = system ?? throw new ArgumentNullException();
      _system.ConnectionChanged += SystemConnectionChanged;
    }

    private void SystemConnectionChanged(bool connected)
    {
      ConnectionChanged?.Invoke(this, new ValueChangedEventArgs(!connected, connected));
    }

    public void Connect(string ip, ushort port)
    {
      try
      {
        _system.Connect(ip, port);
      }
      catch (G5ApiException g5ApiException)
      {
        NotifyErrorMessageChanged(g5ApiException.Message);
      }
    }

    public void Disconnect()
    {
      try
      {
        _system.Disconnect();
      }
      catch (G5ApiException g5ApiException)
      {
        NotifyErrorMessageChanged(g5ApiException.Message);
      }
    }
  }
}
